/*+ ComSelect.cpp
 *
 ******************************************************************************
 *
 *                        Trimble Navigation Limited
 *                           645 North Mary Avenue
 *                              P.O. Box 3642
 *                         Sunnyvale, CA 94088-3642
 *
 ******************************************************************************
 *
 *    Copyright  2005 Trimble Navigation Ltd.
 *    All Rights Reserved
 *
 ******************************************************************************
 *
 * Description:
 *    This file implements the CComSelect class.
 *            
 * Revision History:
 *    05-18-2005    Mike Priven
 *                  Written
 *
 * Notes:
 *
-*/

/*---------------------------------------------------------------------------*\
 |                         I N C L U D E   F I L E S
\*---------------------------------------------------------------------------*/
#include "stdafx.h"
#include "TsipDemo.h"
#include "ComSelect.h"
#include "TsipWindow.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*---------------------------------------------------------------------------*\
 |                    M E T H O D   D E F I N I T I O N S
\*---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
Function:       <constructor>

Description:    A constructor for this class. Called when a new object of this
                class is created.

Parameters:     pParent - a pointer to the parent window - the window that
                created an object of this class.

Return Value:   none
-----------------------------------------------------------------------------*/
CComSelect::CComSelect(CWnd* pParent /*=NULL*/)
    : CDialog(CComSelect::IDD, pParent)
{
    m_pParent = (CTsipWindow*)pParent;
    //{{AFX_DATA_INIT(CComSelect)
    m_bSetRcvr = FALSE;
    //}}AFX_DATA_INIT
}

/*-----------------------------------------------------------------------------
Function:       DoDataExchange

Description:    Called by the framework to exchange and validate dialog data.
                Never call this function directly. It is called by the 
                UpdateData() member function

Parameters:     pDX - a pointer to a CDataExchange object

Return Value:   none
-----------------------------------------------------------------------------*/
void CComSelect::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CComSelect)
    DDX_Control(pDX, IDC_COM_STOP, m_lstComStop);
    DDX_Control(pDX, IDC_COM_DATA, m_lstComData);
    DDX_Control(pDX, IDC_COM_PORT, m_lstComPort);
    DDX_Control(pDX, IDC_COM_BAUD, m_lstComBaud);
    DDX_Control(pDX, IDC_COM_PARITY, m_lstComParity);
    //}}AFX_DATA_MAP
}

/*-----------------------------------------------------------------------------
Function:       BEGIN_MESSAGE_MAP (theClass, baseClass)

Description:    Defines a message map for this class. Matches a windows message
                with a callback function. The framework will call this function
                once the message associated with it has been received.

Parameters:     theClass - specifies the name of the class whose message map
                this is
                baseClass - specifies the name of the base class of theClass

Return Value:   none
-----------------------------------------------------------------------------*/
BEGIN_MESSAGE_MAP(CComSelect, CDialog)
    //{{AFX_MSG_MAP(CComSelect)
    ON_WM_CLOSE()
    //}}AFX_MSG_MAP
    ON_BN_CLICKED(ID_CLOSE, OnClose)
END_MESSAGE_MAP()

/*-----------------------------------------------------------------------------
Function:       OnCancel

Description:    This function is automatically called when the Escape key is 
                hit

Parameters:     none

Return Value:   none
-----------------------------------------------------------------------------*/
void CComSelect::OnCancel() 
{
}

/*-----------------------------------------------------------------------------
Function:       OnClose
    
Description:    This function is automatically called when a close button in
                in the upper right corner of the window is clicked on
                (the title-bar button with a cross). 

Parameters:     none

Return Value:   none
-----------------------------------------------------------------------------*/
void CComSelect::OnClose() 
{
    EndDialog(IDCANCEL);
}

/*-----------------------------------------------------------------------------
Function:       OnInitDialog

Description:    Initialises the dialog box. This is a standard MFC function 
                called automatically after the dialog has been created but 
                before it is displayed.

Parameters:     none

Return Value:   specifies whether the application has set the input focus to 
                one of the controls in the dialog box
-----------------------------------------------------------------------------*/
BOOL CComSelect::OnInitDialog() 
{
    CString str;

    CDialog::OnInitDialog();
    
    for (int i=0; i<m_pParent->m_Ports.GetSize(); i++) 
    {
        str.Format("COM %d",m_pParent->m_Ports[i]);
        if (m_lstComPort.FindString(-1,str) == CB_ERR)
        {
            m_lstComPort.AddString(str);
        }
    }

    if (m_pParent->m_SerialPort.GetPort() > 0) 
    {
        str.Format("COM %d",m_pParent->m_SerialPort.GetPort());
        m_lstComPort.SelectString(-1,str);

        str.Format("%d",m_pParent->m_SerialPort.GetBaud());
        m_lstComBaud.SelectString(-1,str);

        m_lstComData.SelectString(-1,"8");

        if (m_pParent->m_SerialPort.GetStopBits() == COM_STOP_BITS_1)
        {
            m_lstComStop.SelectString(-1,"1");
        }
        else
        {
            m_lstComStop.SelectString(-1,"2");
        }

        switch (m_pParent->m_SerialPort.GetParity()) 
        {
            case COM_PARITY_ODD:    
                m_lstComParity.SelectString(-1,CString("Odd")); 
                break;
            case COM_PARITY_EVEN:   
                m_lstComParity.SelectString(-1,CString("Even"));    
                break;
            default:    
                m_lstComParity.SelectString(-1,CString("None"));    
                break;
        }
    }

    return TRUE;
}

/*-----------------------------------------------------------------------------
Function:       OnOK

Description:    This function is automatically called when the OK button is
                pressed on the Receiver Configuration dialog box

Parameters:     none

Return Value:   none
-----------------------------------------------------------------------------*/
void CComSelect::OnOK() 
{
    CString str;

    if (UpdateData(true)) 
    {
        m_lstComPort.GetLBText(m_lstComPort.GetCurSel(),str);
        int nPort = atoi(str.Mid(str.Find('M',0)+1,
                                 str.GetLength()-str.Find('M',0)));
        if (str == "<OFF>")
        {
            m_pParent->m_SerialPort.SetPort(0);
        }
        else 
        {
            m_pParent->m_SerialPort.SetPort(nPort);
            m_lstComBaud.GetLBText(m_lstComBaud.GetCurSel(),str);
            m_pParent->m_SerialPort.SetBaud(atoi(str));
            switch(m_lstComParity.GetCurSel()) 
            {
                case 1:  m_pParent->m_SerialPort.SetParity(COM_PARITY_ODD);  break;
                case 2:  m_pParent->m_SerialPort.SetParity(COM_PARITY_EVEN); break;
                default: m_pParent->m_SerialPort.SetParity(COM_PARITY_NONE); break;
            }
            if (m_lstComStop.GetCurSel() == 0)
            {
                m_pParent->m_SerialPort.SetStopBits(COM_STOP_BITS_1);
            }
            else
            {
                m_pParent->m_SerialPort.SetStopBits(COM_STOP_BITS_2);
            }
        }
    }

    CDialog::OnOK();
}
